import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import getTokenHelper from "../../../../../utils/getTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.locatorId) {
    newObjValue = {...newObjValue, 
      M_Locator_ID: {
        id: body.locatorId,
        tableName: 'M_Locator'
      }
    }
  }
  if(body.productId) {
    newObjValue = {...newObjValue, 
      M_Product_ID: {
        id: body.productId,
        tableName: 'M_Product'
      }
    }
  }
  if(body.attributeSetInstanceId) {
    newObjValue = {...newObjValue, 
      M_AttributeSetInstance_ID: {
        id: body.attributeSetInstanceId,
        tableName: 'M_AttributeSetInstance'
      }
    }
  }
  if(body.inventoryTypeId) {
    newObjValue = {...newObjValue, 
      InventoryType: {
        id: body.inventoryTypeId
      }
    }
  }
  if(body.chargeId) {
    newObjValue = {...newObjValue, 
      C_Charge_ID: {
        id: body.chargeId,
        tableName: 'C_Charge'
      }
    }
  }

  if(body.inventoryId) {
    const res: any = await fetchHelper(event, 'models/m_inventoryline', 'POST', token, {
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      },
      isActive: body.isActive,
      line: body.line,
      description: body.description,
      //value: body.value,
      //UPC: body.upc,
      qtyCount: body.qtyCount,
      qtyBook: body.qtyBook,
      //qtyCsv: body.qtyCsv,
      //qtyInternalUse: body.qtyInternalUse,
      //currentCostPrice: body.currentCostPrice,
      //newCostPrice: body.newCostPrice,
      //processed: body.processed,
      M_Inventory_ID: {
        id: body.inventoryId,
        tableName: 'M_Inventory'
      },
      ...newObjValue,
      tableName: 'm_inventoryline'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    if(err.status >= 500 || err.statusCode >= 500) {
      data = {
        status: err.status || err.statusCode,
        message: err.detail || err.details || err.message || err.statusMessage
      }
    } else {
    try {
        let authToken: any = await refreshTokenHelper(event)
        data = await handleFunc(event, authToken)
      } catch(error: any) {
        data = {
          status: error.status || error.statusCode || 500,
          message: error.detail || error.details || error.message || error.statusMessage
        }
        forceLogoutHelper(event, data)
      }
    }
  }

  return data
})